
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.BO
{
    public class Student : PI.FM.N000.Base.BL.BO.Base
    {
        public Student(Gemini.Core.BL.Interface.DBD.IDBDBase DBDBase)
            : base(DBDBase) { }

        #region Public members
        public long? UserID
        {
            get { return GetValue<long?>("UserID"); }
            set { SetValue<long?>("UserID", value); }
        }
        public string Email
        {
            get { return GetValue<string>("Email"); }
            set { SetValue<string>("Email", value); }
        }
        public int? IndexNr
        {
            get { return GetValue<int?>("IndexNr"); }
            set { SetValue<int?>("IndexNr", value); }
        }
        public long? ClassID
        {
            get { return GetValue<long?>("ClassID"); }
            set { SetValue<long?>("ClassID", value); }
        }
        public string Forename
        {
            get { return GetValue<string>("Forename"); }
            set { SetValue<string>("Forename", value); }
        }
        public string Surename
        {
            get { return GetValue<string>("Surename"); }
            set { SetValue<string>("Surename", value); }
        }
        public bool? Sex
        {
            get { return GetValue<bool?>("Sex"); }
            set { SetValue<bool?>("Sex", value); }
        }

        ///Bierzcy poziom trudnoci na ktrym znajduje si ucze
        ///Uwaga! W nowej wersji poziom trudnoci jest ustalany przez pocztkowy test umiejtnoci a nastpnie na bierzco modyfikowany
        public long? CurrentAdvancedLevelID
        {
            get { return GetValue<long?>("CurrentAdvancedLevelID"); }
            set { SetValue<long?>("CurrentAdvancedLevelID", value); }
        }

        public long? CurrentEvaluationSheetID
        {
            get { return GetValue<long?>("CurrentEvaluationSheetID"); }
            set { SetValue<long?>("CurrentEvaluationSheetID", value); }
        }       

        public int? CompetencePointsByWeight
        {
            get { return GetValue<int?>("CompetencePointsByWeight"); }
            set { SetValue<int?>("CompetencePointsByWeight", value); }
        }
        public int? CompetenceMaxPoints
        {
            get { return GetValue<int?>("CompetenceMaxPoints"); }
            set { SetValue<int?>("CompetenceMaxPoints", value); }
        }
        /// <summary>
        /// rednia ocena z wykonania Competence Course
        /// Liczona na podstawie CompetencePointsByWeight i CompetenceMaxPoints
        /// </summary>
        public long? CompetenceEvaluationSheetID
        {
            get { return GetValue<long?>("CompetenceEvaluationSheetID"); }
            set { SetValue<long?>("CompetenceEvaluationSheetID", value); }
        }

        /// <summary>
        /// Punkty z Case Study rozumiemy jako ilo rozwizanych rozdziaw
        /// </summary>
        public int? CaseStudyPoints
        {
            get { return GetValue<int?>("CaseStudyPoints"); }
            set { SetValue<int?>("CaseStudyPoints", value); }
        }

        /// <summary>
        /// Maksymalna ilo punktw z Case Study rozumiemy jako sume iloci wszystkich rozdziaw jakie rozwizywa ucze
        /// </summary>
        public int? CaseStudyMaxPoints
        {
            get { return GetValue<int?>("CaseStudyMaxPoints"); }
            set { SetValue<int?>("CaseStudyMaxPoints", value); }
        }

        public int? AdvancedTestStartPoints
        {
            get { return GetValue<int?>("AdvancedTestStartPoints"); }
            set { SetValue<int?>("AdvancedTestStartPoints", value); }
        }

        public int? AdvancedTestStartMaxPoints
        {
            get { return GetValue<int?>("AdvancedTestStartMaxPoints"); }
            set { SetValue<int?>("AdvancedTestStartMaxPoints", value); }
        }

        public long? AdvancedTestStartEvaluationSheetID
        {
            get { return GetValue<long?>("AdvancedTestStartEvaluationSheetID"); }
            set { SetValue<long?>("AdvancedTestStartEvaluationSheetID", value); }
        }
        
        public int? AdvancedTestEndPoints
        {
            get { return GetValue<int?>("AdvancedTestEndPoints"); }
            set { SetValue<int?>("AdvancedTestEndPoints", value); }
        }
        
        public int? AdvancedTestEndMaxPoints
        {
            get { return GetValue<int?>("AdvancedTestEndMaxPoints"); }
            set { SetValue<int?>("AdvancedTestEndMaxPoints", value); }
        }

        public long? AdvancedTestEndEvaluationSheetID
        {
            get { return GetValue<long?>("AdvancedTestEndEvaluationSheetID"); }
            set { SetValue<long?>("AdvancedTestEndEvaluationSheetID", value); }
        }
        
        public int? KnowledgeTestStartPoints
        {
            get { return GetValue<int?>("KnowledgeTestStartPoints"); }
            set { SetValue<int?>("KnowledgeTestStartPoints", value); }
        }
        
        public int? KnowledgeTestStartMaxPoints
        {
            get { return GetValue<int?>("KnowledgeTestStartMaxPoints"); }
            set { SetValue<int?>("KnowledgeTestStartMaxPoints", value); }
        }

        public long? KnowledgeTestStartAdvancedLevelID
        {
            get { return GetValue<long?>("KnowledgeTestStartAdvancedLevelID"); }
            set { SetValue<long?>("KnowledgeTestStartAdvancedLevelID", value); }
        }
        
        public int? KnowledgeTestEndPoints
        {
            get { return GetValue<int?>("KnowledgeTestEndPoints"); }
            set { SetValue<int?>("KnowledgeTestEndPoints", value); }
        }
        
        public int? KnowledgeTestEndMaxPoints
        {
            get { return GetValue<int?>("KnowledgeTestEndMaxPoints"); }
            set { SetValue<int?>("KnowledgeTestEndMaxPoints", value); }
        }

        public long? KnowledgeTestEndAdvancedLevelID
        {
            get { return GetValue<long?>("KnowledgeTestEndAdvancedLevelID"); }
            set { SetValue<long?>("KnowledgeTestEndAdvancedLevelID", value); }
        }

        public decimal? Salary
        {
            get { return GetValue<decimal?>("Salary"); }
            set { SetValue<decimal?>("Salary", value); }
        }

        public decimal? GameCash
        {
            get { return GetValue<decimal?>("GameCash"); }
            set { SetValue<decimal?>("GameCash", value); }
        }

        public int? ResetCount
        {
            get { return GetValue<int?>("ResetCount"); }
            set { SetValue<int?>("ResetCount", value); }
        }

        public int? CompetencePartDone
        {
            get { return GetValue<int?>("CompetencePartDone"); }
            set { SetValue<int?>("CompetencePartDone", value); }
        }

        public int? Flags
        {
            get { return GetValue<int?>("Flags"); }
            set { SetValue<int?>("Flags", value); }
        }        
        #endregion

        public override string DisplayValue
        {
            get
            {
                return String.Format("{0} {1}", Forename, Surename);
            }
        }

        public int AdvancedTestStartPointsPercent
        {
            get
            {
                return BasicUtility.PointPercent(AdvancedTestStartPoints, AdvancedTestStartMaxPoints);
            }
        }
        public int AdvancedTestEndPointsPercent
        {
            get
            {
                return BasicUtility.PointPercent(AdvancedTestEndPoints, AdvancedTestEndMaxPoints);
            }
        }
        public int KnowledgeTestStartPointsPercent
        {
            get
            {
                return BasicUtility.PointPercent(KnowledgeTestStartPoints, KnowledgeTestStartMaxPoints);
            }
        }
        public int KnowledgeTestEndPointsPercent
        {
            get
            {
                return BasicUtility.PointPercent(KnowledgeTestEndPoints, KnowledgeTestEndMaxPoints);
            }
        }
        public int CaseStudyPointsPercent
        {
            get
            {
                return BasicUtility.PointPercent(CaseStudyPoints, CaseStudyMaxPoints);
            }
        }
        public int CompetencePointsPercent
        {
            get
            {
                return BasicUtility.PointPercent(CompetencePointsByWeight, CompetenceMaxPoints);
            }
        }
        public double CompetencePartDoneAvg
        {
            get
            {
                if (ResetCount.HasValue && CompetencePartDone.HasValue && CompetencePartDone > 0)
                {
                    return Convert.ToDouble(ResetCount) / Convert.ToDouble(CompetencePartDone);
                }
                return 0;
            }
        }
        public int SalaryValue
        {
            get
            {
                return Salary.HasValue ? Convert.ToInt32(Salary) : 0;
            }
        }
        public int GameCashValue
        {
            get
            {
                return GameCash.HasValue ? Convert.ToInt32(GameCash) : 0;
            }
        }

        /// <summary>
        /// Haslo na potrzeby API do EduFarmy uzupelniane podczas
        /// przetwarzania obiektu API.Model.GStudent na obiekt BO.Student
        /// A take do transportu hasa z warstwy prezentacji np przy zmianie hasa
        /// </summary>
        public string TmpPassword { get; set; }

        /// <summary>
        /// Zwraca studenta, nalezy pamietac o ustawieniu property VirtualPassword !!
        /// </summary>
        /// <returns></returns>
        internal BL.API.Model.GStudent GetApiObject()
        {
            return new API.Model.GStudent() { email = Email, id = UserID.ToString(), name = Forename, surname = Surename, class_id = ClassID.HasValue ? ClassID.ToString() : string.Empty, salary = Salary.HasValue ? Convert.ToInt32(Salary.Value).ToString() : "0" };
        }

        /// <summary>
        /// Metoda przepisuje dane z obiektu API do obiektu studenta BO
        /// </summary>
        /// <param name="Student"></param>
        internal void Assign(API.Model.GStudent Student)
        {
            UserID = long.Parse(Student.id);
            Forename = Student.name;
            Surename = Student.surname;
            ClassID = string.IsNullOrEmpty(Student.class_id) ? null : (long?)long.Parse(Student.class_id);
            if (!string.IsNullOrEmpty(Student.salary))
            {
                int _s = 0;
                if (int.TryParse(Student.salary, out _s))
                {
                    Salary = _s;
                }
            }
        }

        #region Search
        public new class Search : PI.FM.N000.Base.BL.BO.Base.Search
        {
            public enum SortOrderType { Class = 1, Name = 2, Salary = 3, CreateDate = 4, SalarySurnameName = 5, GameCashSurnameName = 6, CurrentAdvancedLevelIDSurnameName = 7, }

            public string   Forename        { get; set; }
            public string   Surename        { get; set; }
            public string   Email           { get; set; }
            public long?    UserID          { get; set; }
            public long?    ClassID         { get; set; }
            public long?    SchoolID        { get; set; }
            public long?    SchoolYearID    { get; set; }
            public long?    InstructorID    { get; set; }
            public int?     IndexNr         { get; set; }            
            public int?     SortOrderID     { get; set; }
            public SortOrderType SortOrder 
            {
                set { SortOrderID = (int)value; }
                get { return (SortOrderType)SortOrderID; }
            }
        }
        #endregion
    }
}
